/*******************************************************
Filename		:  create_habitat_temp_tables.sql
Release 		:  c2.0
SIR			:  1496
Description		:  create temp tables for habitat result processing
Author			:  Bill Nash
Date			:  7-07-2003
Comments		:  Created based on Regular Result ETLs
			:  08/25/2003 fix date/time  WN
                     	   8/27/2003 - SIR 1495 TIR#7 - Nullified well_number and pipe_number when point type not 'WELL HEAD' or
                                 'END OF PIPE'. -C Tsang
			   01/16/2004 - SIR 1586 Moved connect string to master install script -JW
			   01/32/2004 - added tsmalp_is_number to HBFDACT_TEMP2 -JW
	06/09/2004 added station_is_number to hbfdact_temp2 table -GT

**********************************************************/
spool create_habitat_temp_tables.log

-- field activity related temp tables.

drop index ihb_act_is_num_org_id;
create index ihb_act_is_num_org_id on FA_HABITAT_RESULT (activity_is_number,organization_id)
tablespace storetindx
storage (initial 10M next 10M);

drop table hbfdact_temp;
create table hbfdact_temp 
tablespace storetdata
storage ( initial 5M next 5M maxextents 500) unrecoverable 
as select distinct activity_is_number,organization_id, 0 flag from FA_HABITAT_RESULT;
commit;

create index hbift_act_is_num_org_id on hbfdact_temp (activity_is_number,organization_id)
tablespace storetindx
storage (initial 3M next 2M);

create bitmap index hbift_flag on hbfdact_temp(flag)
tablespace storetindx
storage (initial 2M next 2M maxextents 500) ;

drop sequence seq_hbfdact_temp2;

create sequence seq_hbfdact_temp2
start with 1 increment by 1 nomaxvalue nocycle cache 100;


-- creating AAL temp tables.
drop table hbtsraal_AP ;
create table hbtsraal_AP 
tablespace storetdata
storage (initial 10M next 5M)
unrecoverable as
select a.* from storet1.tsraal a, storet1.tsmalp p
where a.tsmalp_is_number = p.tsmalp_is_number
and   a.tsmalp_org_id = p.tsmalp_org_id
and p.type_code = 'ACTIVITY POINT'
AND  a.TSRAAL_TYPE_NAME in ('General','Trawl Stop');

create index hbind_aal_ap_01 on hbtsraal_ap(TSMALP_IS_NUMBER,TSMALP_ORG_ID,TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID,TSRAAL_TYPE_NAME)
tablespace storetindx
storage (initial 5M next 3M);

create index hbind_aal_ap_02 on hbtsraal_ap(TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID)
tablespace storetindx
storage (initial 5M next 3M);

drop table hbtsraal_nap ;
create table hbtsraal_nap 
tablespace storetdata
storage (initial 10M next 5M)
unrecoverable as
select a.* from storet1.tsraal a, storet1.tsmalp p
where a.tsmalp_is_number = p.tsmalp_is_number
and   a.tsmalp_org_id = p.tsmalp_org_id
and p.type_code != 'ACTIVITY POINT';

create index hbind_aal_nap_01 on 
hbtsraal_nap(TSMALP_IS_NUMBER,TSMALP_ORG_ID,TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID,TSRAAL_TYPE_NAME)
tablespace storetindx
storage (initial 5M next 3M);

create index hbind_aal_nap_02 on hbtsraal_nap(TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID)
tablespace storetindx
storage (initial 5M next 3M);
-- creating fdact_temp2 table
drop table hbfdact_temp2;
create table hbfdact_temp2 
tablespace storetdata
storage (initial 20M next 10M)
unrecoverable as
select seq_hbfdact_temp2.nextval activity_isn, ft.activity_is_number , ft.organization_id,
 nvl(AP_ALP.TYPE_CODE,nap_ALP.TYPE_CODE)				LOCATION_POINT_TYPE,
--added 1/21
 nvl(AP_ALP.tsmalp_is_number,nap_ALP.tsmalp_is_number)			tsmalp_is_number,
 nvl(AP_ALP.SEQUENCE_NUMBER,nap_ALP.SEQUENCE_NUMBER)		POINT_SEQUENCE_NUMBER,
  W.ID_NUMBER well_number,
  p.ID_NUMBER pipe_number,
  NVL(AP_ALP.LAT_DEC_DEG_MSR,nap_ALP.LAT_DEC_DEG_MSR)  activity_LATITUDE,
  NVL(AP_ALP.LONG_DEC_DEG_MSR,nap_ALP.LONG_DEC_DEG_MSR) activity_LONGITUDE,
  NVL(AP_ALP.POINT_NAME,nap_ALP.POINT_NAME) POINT_NAME,
  NVL(AP_ALP.GEOPSTNG_SCALE_TXT,nap_ALP.GEOPSTNG_SCALE_TXT) MAP_SCALE,
  nvl(ap_mad_hd.pk_isn,nap_mad_hd.pk_isn) FK_act_mad_hdatum,
  nvl(ap_mad_hm.pk_isn,nap_mad_hm.pk_isn) fk_act_mad_hmethod,
  nap_alp.tsmstatn0is_number station_is_number
from hbtsraal_ap ap_aal, storet1.tsmalp ap_alp,hbtsraal_nap nap_aal, storet1.tsmalp nap_alp,storet1.tsmwell w, 
   storet1.tsmpipe p,storetw.lu_mad_hmethod ap_mad_hm, storetw.lu_mad_hdatum ap_mad_hd,
   storetw.lu_mad_hmethod nap_mad_hm, storetw.lu_mad_hdatum nap_mad_hd, hbfdact_temp ft
where  FT.activity_IS_NUMBER = AP_AAL.TSRFDACT_IS_NUMBER (+)
AND FT.organization_id = AP_AAL.TSRFDACT_ORG_ID (+)
AND AP_AAL.TSMALP_IS_NUMBER  = AP_ALP.TSMALP_IS_NUMBER (+)
AND AP_AAL.TSMALP_ORG_ID  = AP_ALP.TSMALP_ORG_ID (+)
AND FT.activity_IS_NUMBER = nap_AAL.TSRFDACT_IS_NUMBER (+)
AND FT.organization_id= nap_AAL.TSRFDACT_ORG_ID (+)
AND nap_AAL.TSMALP_IS_NUMBER  = NAP_ALP.TSMALP_IS_NUMBER (+)
AND nap_AAL.TSMALP_ORG_ID  = NAP_ALP.TSMALP_ORG_ID (+)
  and nap_alp.tsmwell_is_number = w.tsmwell_is_number (+)
  and nap_alp.tsmwell_org_id = w.tsmwell_org_id (+)
  and nap_alp.tsmpipe_is_number = p.tsmpipe_is_number (+)
  and nap_alp.tsmpipe_org_id = p.tsmpipe_org_id (+)
  and ap_alp.geopstng_datum_cd = ap_mad_hd.id_code (+)
  and ap_alp.geopstng_method_cd = ap_mad_hM.id_code (+)
  and nap_alp.geopstng_datum_cd = nap_mad_hd.id_code (+)
  and nap_alp.geopstng_method_cd = nap_mad_hM.id_code (+);

update hbfdact_temp2
set WELL_NUMBER = null
where rtrim(LOCATION_POINT_TYPE) <> 'WELL HEAD';
commit;

update hbfdact_temp2
set PIPE_NUMBER = null
where rtrim(LOCATION_POINT_TYPE) <> 'END OF PIPE';
commit;

create index hbift2_act_isnorgid on hbfdact_temp2(activity_is_number,organization_id) 
tablespace storetindx
storage (initial 5M next 5M);

--field set temp table
drop table hbfieldset_temp;
create table hbfieldset_temp
tablespace storetdata
storage (initial 10M next 5M)
unrecoverable as
SELECT activity_isn, f_fieldset(ACTIVITY_IS_NUMBER, ORGANIZATION_ID) field_set
	FROM hbfdact_temp2 ft2;
DELETE FROM hbfieldset_temp WHERE field_set IS NULL;
COMMIT;

-- Station information related temp table.
drop table hbstatninfo_temp;
create table hbstatnINFO_temp
tablespace storetdata
storage (initial 20M next 10M)
unrecoverable as
SELECT
STATN.IDENTIFICATION_CD STATION_ID,
STATN.NAME station_name,
TRIP.ID_CODE trip_id,
TRIP.NAME trip_name,
STVST.ID_NUMBER STATION_VISIT_ID,
STATN.TSMSTATN_IS_NUMBER,
STVST.TSRSTVST_IS_NUMBER,
STVST.TSRSTVST_ORG_ID,
--
TO_DATE(DECODE (to_char(STVST.ARRIVAL_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(STVST.ARRIVAL_DATE,'DD-MON-YYYY')||'-'||to_char(STVST.ARRIVAL_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') VISIT_START_DATE_TIME,
--
--TO_DATE(to_char(STVST.ARRIVAL_DATE,'DD-MON-YYYY')||'-'||to_char(STVST.ARRIVAL_TIME,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS') VISIT_START_DATE_TIME, 
--STVST.ARRIVAL_DATE		VISIT_START_DATE,
--STVST.ARRIVAL_TIME		VISIT_START_TIME,
STVST.ARRIVAL_TIME_ZONE		VISIT_START_TIME_ZONE,
--
TO_DATE(DECODE (to_char(STVST.DEPARTURE_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(STVST.DEPARTURE_DATE,'DD-MON-YYYY')||'-'||to_char(STVST.DEPARTURE_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') VISIT_STOP_DATE_TIME,
--
--TO_DATE(to_char(STVST.DEPARTURE_DATE,'DD-MON-YYYY')||'-'||to_char(STVST.DEPARTURE_TIME,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS') VISIT_STOP_DATE_TIME, 
--STVST.DEPARTURE_DATE		VISIT_STOP_DATE,
--STVST.DEPARTURE_TIME		VISIT_STOP_TIME,
STVST.DEPRTURE_TIME_ZONE	VISIT_STOP_TIME_ZONE
  FROM storet1.TSMSTATN STATN,
   storet1.TSRTRIP TRIP,
   storet1.TSRSTVST STVST
  WHERE STVST.TSRTRIP_IS_NUMBER = TRIP.TSRTRIP_IS_NUMBER
   AND STVST.TSRTRIP_ORG_ID = TRIP.TSRTRIP_ORG_ID
   AND STVST.TSMSTATN_IS_NUMBER = STATN.TSMSTATN_IS_NUMBER
   AND STVST.TSMSTATN_ORG_ID = STATN.TSMSTATN_ORG_ID;

create index hbisi_temp_stvstkey on hbstatninfo_temp(tsrstvst_is_number,tsrstvst_org_id)
tablespace storetindx
storage (initial 10M next 10M);

commit;

--check fdact_temp2 data for data problems.
-- This query should not yield any rows.  If any rows are returned then fix the bad data before proceding.

select 'Note:  Following select should not yield any rows. If it returns rows then there is problem with fdact_temp2 data.' from dual;

select activity_is_number,organization_id,count(*)
from hbfdact_temp2
group by activity_is_number,organization_id
having count(*)  > 1;

select 'Following delete statement fixes the fdact_temp2 data by deleting duplicate rows by keeping max(rowid)' from dual;

delete from hbfdact_temp2 a
where a.rowid < (select max(b.rowid) from hbfdact_temp2 b
         where b.activity_is_number = a.activity_is_number
           and b.organization_id = a.organization_id);

commit;

-- lab remark related temp tables.

DROP TABLE hbrlra_temp;
create table hbrlra_temp
tablespace storetdata
storage (initial 10M next 10M)
unrecoverable as
select distinct tsrrsult_is_number,tsrrsult_org_id
from storet1.tsrrlra;

DROP TABLE  hblbrmk_temp;
create table hblbrmk_temp
tablespace storetdata
storage (initial 4M next 2M)
unrecoverable as
select tsrrsult_is_number,tsrrsult_org_id,flbrmk(tsrrsult_is_number,tsrrsult_org_id) lbrmk
from hbrlra_temp;

create index hbilbrmk_temp_01 on hblbrmk_temp(tsrrsult_is_number,tsrrsult_org_id)
tablespace storetindx
storage(initial 4M next 4M);

create index ihb_result_lbrmk_01 on FA_HABITAT_RESULT(result_is_number,organization_id)
tablespace storetindx
storage(initial 10M next 10M);

analyze table hblbrmk_temp compute statistics;
analyze index hbilbrmk_temp_01 compute statistics;
analyze index ihb_result_lbrmk_01 compute statistics;

spool off
